package org.msh.tb.reports2.variables;

import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.MicroscopyResult;

import java.util.List;

/**
 * Created by rmemoria on 20/12/16.
 */
public class MicroscopyResultGroupVariable extends LabResultDiagVariable {

    public MicroscopyResultGroupVariable() {
        super("mic-res-group", "manag.reportgen.var.micdiaggroup", "exammicroscopy.result", MicroscopyResult.class, UnitType.CASE_ONLY);
    }

    @Override
    public Key createKey(Object value, int iteration) {
        if (value == null) {
            return Key.asNull();
        }

        int index = (Integer)value;

        MicroscopyResult res = MicroscopyResult.values()[index];

        if (res.isPositive()) {
            return Key.of(MicroscopyResult.POSITIVE);
        }

        if (res.isNegative()) {
            return Key.of(MicroscopyResult.NEGATIVE);
        }

        return Key.asNull();
    }

    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        String[] vals = value.getElements();

        String newval = "";
        String sep = "";
        for (String s: vals) {
            newval += sep + convertValue(s);
            sep = ";";
        }

        ValueHandler newvalHandler = new ValueHandler(newval, true);

        super.prepareFilterQuery(def, oper, newvalHandler);
    }

    private String convertValue(String val) {
        if ("POSITIVE".equals(val)) {
            return MicroscopyResult.POSITIVE.toString() + ";" +
                    MicroscopyResult.PLUS.toString() + ";" +
                    MicroscopyResult.PLUS2.toString() + ";" +
                    MicroscopyResult.PLUS3.toString() + ";" +
                    MicroscopyResult.PLUS4.toString();
        }

        return val;
    }
}
